#!/bin/bash

READLINK=`which readlink`

if which readlink >/dev/null; then
	# if readlink exists, follow the symlink and find relatively
	CURR_PATH="$(dirname $($READLINK -f $0))"

else
	if [ ! -L $0 ]; then
		# if path is not a symlink, find relatively
		CURR_PATH="$(dirname $0)"
	else
		CURR_PATH="$( cd "$( dirname "${BASH_SOURCE[0]}" )" && pwd -P )"
	fi
fi
echo $CURR_PATH

DISTDIR=$CURR_PATH
sudo mkdir -p /opt/tashan/etc
sudo mkdir -p /opt/tashan/var/run/

$DISTDIR/bin/ssh-keygen -t rsa -f /opt/tashan/etc/ssh_host_rsa_key
$DISTDIR/bin/ssh-keygen -t dsa -f /opt/tashan/etc/ssh_host_dsa_key
$DISTDIR/bin/ssh-keygen -t ecdsa -f /opt/tashan/etc/ssh_host_ecdsa_key
$DISTDIR/bin/ssh-keygen -t ed25519 -f /opt/tashan/etc/ssh_host_ed25519_key




